class Queue:
    """
    First-in, first-out (FIFO) Queue.
    """

    def __init__(self):
        """
        Create a new, empty Queue self.

        @param Queue self: this Queue
        @rtype: None
        """
        self._contents = []

    def add(self, obj):
        """
        Add object obj to end of Queue self.

        @param Queue self: this Queue
        @param object obj: object to place on Queue
        @rtype: None
        """
        self._contents.append(obj)

    def remove(self):
        """
        Remove and return first element of Queue self.

        Assume Queue self is not empty.

        @param Queue self: this Queue
        @rtype: object

        >>> s = Queue()
        >>> s.add(5)
        >>> s.add(7)
        >>> s.remove()
        5
        """
        return self._contents.pop(0)

    def is_empty(self):
        """
        Return whether Queue self is empty.

        @param Queue self: this Queue
        @rtype: bool
        """
        return len(self._contents) == 0

    def __str__(self):
        """
        Return a str representation of Queue self.

        @param Queue self: this Queue
        @rtype: str

        >>> s = Queue()
        >>> s.add(3)
        >>> s.add(2)
        >>> print(s)
        [3, 2]
        """
        return str(self._contents)

    def __eq__(self, other):
        """
        Return whether Queue self is equivalent to other.

        @param Queue self: this Queue
        @param object|Queue other: object to compare to self.
        @rtype: bool

        >>> s1 = Queue()
        >>> s1.add(3)
        >>> s2 = Queue()
        >>> s2.add(3)
        >>> s1 == s2
        True
        """
        return (type(self) == type(other) and
                self._contents == other._contents)


if __name__ == "__main__":
    import doctest
    doctest.testmod()
