from node import LinkedList
from container import Container


class Queue(Container):
    """
    First-in, first-out (FIFO) Queue.
    """

    def __init__(self):
        """
        Create a new, empty Queue self.

        Overrides Container.__init__

        @param Queue self: this Queue
        @rtype: None
        """
        self._list = LinkedList()

    def add(self, obj):
        """
        Add object obj to top of Queue self.

        @param Queue self: this Queue
        @param object obj: object to place on Queue
        @rtype: None
        """
        self._list.append(obj)

    def remove(self):
        """
        Remove and return top element of Queue self.

        Assume Queue self is not empty.

        @param Queue self: this Queue
        @rtype: object

        >>> s = Queue()
        >>> s.add(5)
        >>> s.add(7)
        >>> s.remove()
        5
        """
        return self._list.delete_front()

    def is_empty(self):
        """
        Return whether Queue self is empty.

        @param Queue self: this Queue
        @rtype: bool
        """
        return self._list.size == 0

if __name__ == "__main__":
    import doctest
    doctest.testmod()
