from container import Container
from stack import Stack
from queue import Queue
import linked_stack
import linked_queue
from time import time


def container_cycle(c, size):
    """
    Time how long it takes to perform stack operations on stacks
    of various sizes.

    @param Container c: container to be timed
    @param int size: number of items to initialize the container with.
    @rtype: None
    """
    # Bypass the interface to create a container of size <size> items,
    # for demonstration purposes. And yes, accessing a private attribute
    # here is definitely cheating!
    c._contents = list(range(size))

    # Use a timer to report how long it takes to add and remove 10000 items
    # on our container. What value we add should make no difference to the time
    # required, so we arbitrarily add 42.
    start = time()
    for i in range(10000):
        c.add(42)
        c.remove()
    print("{:8.0f} items: 10000 add/remove operations in {} seconds"
          .format(size, time() - start))

if __name__ == "__main__":
    s = Stack()  # stack we implemented using a regular Python list
    q = Queue()  # queue we implemented using a regular Python list
    ls = linked_stack.Stack()  # stack implemented using linked list
    lq = linked_queue.Queue()  # queue implemented using linked list
    # what do we expect the timing to be?
    print("========\n Linked stack")
    for j in [1000, 10000, 100000, 1000000]:
        container_cycle(ls, j)
    print("========\n Stack")
    for j in [1000, 10000, 100000, 1000000]:
        container_cycle(s, j)
    print("========\n Linked queue")
    for j in [1000, 10000, 100000, 1000000]:
        container_cycle(lq, j)
    print("========\n Queue")
    for j in [1000, 10000, 100000, 1000000]:
        container_cycle(q, j)
